function [buf,SampleRate]=udpspecmon(skt,SamplesToGet)
%[buf,SampleRate,adcpins]=udpadcmon(skt,SamplesToGet)  
% Functon showing how to use PIC board as adc that can be monitored
% by many other processes or processors
%
% See function udpadc for how to set up the PIC
pkg load signal;
pins=(16:-1:1).*([zeros(1,16) uint8(dec2bin(udpget(skt,'AD1CSSL')))-'0']((end-15):end));
pidx=find(pins>0);
adcpins=pins(pidx)-1; % work out what pins are used in adc and hence NumChan
NumChan=max(size(adcpins));

if min(size(findname(skt.name,'ANSELA',1:max(size(skt.name)))))>0
  %EP CHIP
   DMA='DMA0STAL';
else
   %FJ or HJ CHIP
   DMA='DMA0STA';
end  
  
CPU_Speed=udpget(skt,'CPU_SPEED');
Timer_Divisor=udpget(skt,'PR5')+1;  % work out sample rate
SampleRate=CPU_Speed/((Timer_Divisor)*NumChan);
DMA_base_addr=udpget(skt,'DMA_BASE');
[d,DMABUF_ADDR]=udpget(skt,'DMABufferA');
[adcval,ADC_ADDR]=udpget(skt,'ADC1BUF0');
DMABufferSize=max(size(d)); % in words not bytes as type is uint16
DMABufferSize=NumChan*floor(DMABufferSize/NumChan); % whole number of sample frames in a buffer
 %treat DMA as fifo and chase the head
buf=ones(NumChan,SamplesToGet)';
fi=(((1:size(buf)(1))-1)*SampleRate/(size(buf)(1)))';
fi=fi(1:(size(fi)(1)/2));
win=hanning(size(buf)(1))*ones(1,size(buf)(2));
pdat=plot(fi,buf(1:(size(buf)(1)/2),:)); 

axis([0 max(fi) -40 60]);
grid on
title(['Auto-Spectrum Analogue Pins' sprintf( ' AN%d',adcpins)]);
xlabel('Hz');
ylabel('dB');
while (size(kbhit(1))(1)<1)  
 tail=(udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1;
 tail=NumChan*floor((tail-1)/NumChan)+1; % Start at first channel
 pause(2/SampleRate); %wait at least 1 sample
 buf=[];
 cnt=0;
 while(cnt<(SamplesToGet*NumChan))
  ptr=(udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1;
  if (tail>ptr)
   data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(DMABufferSize-tail+1)*2);
   buf=[buf data];
   cnt=cnt+DMABufferSize-tail+1;
   tail=1; 
   end 
  if (ptr>tail) 
   data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(ptr-tail)*2);
   buf=[buf data];
   cnt=cnt+ptr-tail;
   tail=ptr;
  end
 end
 buf=udpgettconv(buf,2,1);
 % Top and tail the buffers
 buf=buf(1:(SamplesToGet*NumChan));
 buf=reshape(buf,NumChan,SamplesToGet)'.*win;
 buff=20*log10(abs(fft(buf))/size(buf)(1));
 buff=buff(1:(size(buf)(1)/2),:);
 for p=1:size(pdat)(1)
  set(pdat(p),'ydata',buff(:,p));
 end
 drawnow; 
end